package gov.va.med.mhv.phr.allergy.decorator;

import java.io.Serializable;
import java.util.Date;


import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import gov.va.med.mhv.phr.transfer.ImpreciseDateComposite;

import com.bea.portlet.PageURL;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.decorator.DecoratorUtils;
import gov.va.med.mhv.phr.transfer.Allergy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Decorator for Allergy Summary page
 */
public class AllergyTableDecorator implements Serializable { 
	private static final long serialVersionUID = 1L;
	private Allergy extractAllergy;
	private gov.va.med.mhv.healthhistory.transfer.Allergy seiAllergy;

    protected static final String UNKNOWN = 
        StringEscapeUtils.escapeHtml("Unknown");
    
    protected static final String VA = 
        StringEscapeUtils.escapeHtml("VA");
    
    protected static final String SELF = 
        StringEscapeUtils.escapeHtml("Self");
    
    private static final Log LOG = LogFactory.getLog(
    		AllergyTableDecorator.class);    
    
    protected static final String BLANK = StringEscapeUtils.escapeHtml("");
    
    HttpServletRequest request;
    HttpServletResponse response;
    public static final String AL_PAGE = "allergy";
    public static final String AL_PORTLET = "allergies_phr";
    public static final String URLPath = "/gov/va/med/mhv/phr/allergy/portlet/viewSEIDetails"; 
    private String detailsLink;
   
    
    /*
     * Constructor for Extract Allergy record
     */
    public AllergyTableDecorator(Allergy allergy) {
        Precondition.assertNotNull("allergy", allergy);    	
    	this.extractAllergy = allergy;
    }
    
    /*
     * Constructor for SEI Allergy record
     */
    public AllergyTableDecorator(gov.va.med.mhv.healthhistory.transfer.Allergy seiAllergy) {
    	this.seiAllergy = seiAllergy;
    }
    
    
    protected static String escapedValueOrBlank(String value) {
        return StringUtils.isBlank(value) ? BLANK : escapedValue(value);
    }

    protected static String escapedValue(String value) {
        return StringEscapeUtils.escapeHtml(value);
    }
    

    
    /**
     * Extract Allergy Summary view
     */    
    
    public String getCollectedOn() {
    	if(getAllergy()!=null){
	        ImpreciseDateComposite observationDate = getAllergy().getObservationDateComposite();
	        if (observationDate == null){
	            return "Unknown";
	        } else if (observationDate.getValue() != null){
	        	return DecoratorUtils.formatDate(observationDate);
	        }  
	        else if (observationDate.getImpreciseValue()!=null){
	        	return observationDate.getImpreciseValue();
	        }
	        else{
	        	return UNKNOWN;
	        }
    	}else{
    		return "";
    	}    	
    }
    
    /*
     * This is used for sorting in the summary view
     */
    public Date getCollectedOnDate() {
    	if(getAllergy()!=null){
	        ImpreciseDateComposite observationDate = getAllergy().getObservationDateComposite();
	        if (observationDate == null){
	            return new Date();
	        } else if (observationDate.getValue() != null){
	        	return DecoratorUtils.removeTime(observationDate.getValue());
	        }  
	        else if (observationDate.getImpreciseValue()!=null){
	        	return new Date();
	        }
	        else{
	        	return new Date();
	        }
    	}else{
    		return new Date();
    	}    	    	
    	
    	
    }

    public String getDashboardCollectedOn() {
    	if(getAllergy()!=null){
	        ImpreciseDateComposite observationDate = getAllergy().getObservationDateComposite();
	        if (observationDate == null){
	            return UNKNOWN;
	        } else if (observationDate.getValue() != null){
	        	return DecoratorUtils.formatDate(observationDate);
	        }  
	        else if (observationDate.getImpreciseValue()!=null){
	        	return observationDate.getImpreciseValue();
	        }
	        else{
	        	return UNKNOWN;
	        }
    	}else{
    		return "";
    	}
    }
    
    public String getReactant() {
        if(getAllergy() != null &&
        		getAllergy().getReactant() != null){
    		return escapedValue(getAllergy().getReactant());
    	}else{
    		return "";
    	}
    }

    public String getFacilityName() {
        if(getAllergy() != null){   	
        	String facilityInfo = getAllergy().getFacilityInfo();
        	return escapedValue(facilityInfo);
        }else{
        	return "";
        }
    }
    
    public String getAllergySource() {
        return VA;
    }

    public String getAllergyReaction() {
        if(getAllergy() != null &&
        		getAllergy().getReaction() != null){
    		return escapedValue(getAllergy().getReaction());
		}else{
			return "";
		}    	
    }    
    
    
    
    /**
     * SEI Allergy view
     */
    public String getSEIAllergyRecord() {
        if(getSEIAllergy() != null &&
        		getSEIAllergy().getAllergy() != null){
    		return escapedValue(getSEIAllergy().getAllergy());
		}else{
			return "";
		}
    }

    public String getSEISeverity() {
    	if(getSEIAllergy().getSeverity()!=null && (!StringUtils.isEmpty(getSEIAllergy().getSeverity().getName()))){
        	String sevName = getSEIAllergy().getSeverity().getName();    		
    		if(sevName.equals("L")){
    			return escapedValue("Mild");
    		}else if(sevName.equals("S")){
    			return escapedValue("Severe");
    		}else if(sevName.equals("M")){
    			return escapedValue("Moderate");
    		}else{
    			return "";
    		}
    	}else{
    		return "";
    	}
    }    

    public String getSEIDate() {
    	Date value = new Date(getSEIAllergy().getEventDate().getTime());
        return DecoratorUtils.formatDate(value);
    }
    
    public Date getSEICollectedOnDate() {
    	return new Date(getSEIAllergy().getEventDate().getTime());
    }    
    
    public String getSEISource() {
           return SELF;
    }
    
    public String getSEIAllergyReaction() {
        if(getSEIAllergy() != null &&
        		getSEIAllergy().getReaction() != null){
    		return escapedValue(getSEIAllergy().getReaction());
		}else{
			return "";
		}
    }
    
    
    public String getURLWithActionOverride(String allergyIDAsString, String idName) {
		PageURL url = PageURL.createPageURL(request, response, AL_PAGE);
		url.addParameter(AL_PORTLET + "_actionOverride", URLPath, false, false);
		url.addParameter(AL_PORTLET + idName, allergyIDAsString, false, false);
    	if(LOG.isDebugEnabled()){
    		LOG.debug("The URL in getURLWithActionOverride method of AllergyTableDecorator: " + 
    				url.toString());
    	}		
		return url.toString();
	}
    
    
    /**
     * Blended Allergy Summary view
     */
    
    public String getDetailsLink() {
    	if(getAllergy()!=null){
    		return "<a href=" + detailsLink + ">" + getAllergy().getReactant() + "</a>";	
    	}else if(getSEIAllergy()!=null && getSEIAllergy().getAllergy()!=null){
        	return "<a href=" + detailsLink + ">" + getSEIAllergy().getAllergy() + "</a>";    		
    	}else{
    		return "";
    	}
    }    
    
    
    public String getBlendedCollectedOn() {
    	if(getAllergy()!=null){
	        ImpreciseDateComposite observationDate = getAllergy().getObservationDateComposite();
	        if (observationDate == null){
	            return UNKNOWN;
	        } else if (observationDate.getValue() != null){
	        	return DecoratorUtils.formatDate(observationDate);
	        }  
	        else if (observationDate.getImpreciseValue()!=null){
	        	return observationDate.getImpreciseValue();
	        }
	        else{
	        	return UNKNOWN;
	        }
    	}else if(getSEIAllergy()!=null && getSEIAllergy().getEventDate()!=null){
        	Date value = new Date(getSEIAllergy().getEventDate().getTime());
            return DecoratorUtils.formatDate(value);
    	}else{
    		return "";
    	}    	
    }
    
    
    public Date getBlendedCollectedOnDate() {    	
    	if(getAllergy()!=null){
	        ImpreciseDateComposite observationDate = getAllergy().getObservationDateComposite();
	        if (observationDate == null){
	        	return new Date();	
	        } else if (observationDate.getValue() != null){
	        	return DecoratorUtils.removeTime(observationDate.getValue());
	        }  
	        else if (observationDate.getImpreciseValue()!=null){
	    		return new Date();	        	
	        }
	        else{
	    		return new Date();	        	
	        }
    	}else if(getSEIAllergy()!=null && getSEIAllergy().getEventDate()!=null){
        	Date value = new Date(getSEIAllergy().getEventDate().getTime());
            return DecoratorUtils.removeTime(value);
    	}else{
    		return new Date();    		
    	}
    
    }
    
     
    public String getBlendedReactant() {
        if(getAllergy() != null &&
        		getAllergy().getReactant() != null){
    		return escapedValue(getAllergy().getReactant());
        }else if(getSEIAllergy()!=null && getSEIAllergy().getAllergy()!=null){
        	return escapedValue(getSEIAllergy().getAllergy());
    	}else{
    		return "";
    	}    
    }
    
    public String getBlendedAllergyReaction() {
        if(getAllergy() != null &&
        		getAllergy().getReaction() != null){
        	return getAllergy().getReaction();
        }else if(getSEIAllergy()!=null && getSEIAllergy().getReaction()!=null){
        	return escapedValue(getSEIAllergy().getReaction());
    	}else{
    		return "";
    	}   
    }
    
    public String getBlendedAllergySource() {
    	if(getAllergy()!=null){
    		return VA;
    	}else{
    		return SELF;
    	} 
    }
    
    public String getBlendedFacilityName() {
    	if(getAllergy()!=null){  		
        	String facilityInfo = getAllergy().getFacilityInfo();
            return escapedValue(facilityInfo);    		
    	}else{
    		return "";
    	}
    }
    

    private Allergy getAllergy() {
        return extractAllergy;
    }
    
    private gov.va.med.mhv.healthhistory.transfer.Allergy getSEIAllergy() {
        return seiAllergy;
    }    

	public Long getId() {
		return extractAllergy.getId();
	}
	
	public Long getSEIId() {
		return seiAllergy.getAllergyId();
	}

	public void setDetailsLink(String detailsLink) {
		this.detailsLink = detailsLink;
	}
	

}
